IF EXISTS(SELECT  * FROM  sys.views WHERE object_id = OBJECT_ID(N'[dbo].V_EST_PROD_CPL_TENTACLE'))
    BEGIN
        DROP VIEW  [dbo].[V_EST_PROD_CPL_TENTACLE];
    END;
GO

CREATE VIEW [dbo].[V_EST_PROD_CPL_TENTACLE]
AS
SELECT 
    dbo.EST_PROD_CPL.CD_EMP
    , dbo.EST_PROD_CPL.CD_FILIAL
    , dbo.EST_PROD_CPL.CD_PROD
    , dbo.EST_PROD_CPL_TRIB_EST.CD_TRIB AS CD_TRIB_VD
    , dbo.EST_PROD_CPL.GAV
    , dbo.EST_PROD_CPL_TRIB_EST.PERC_RED AS PERC_RED_VD
    , dbo.EST_PROD_CPL.PRAT
    , dbo.EST_PROD_CPL.QT_EST
    , dbo.EST_PROD_CPL.TP_PROD
    , dbo.EST_PROD_CPL.VLR_CUSTO
    , dbo.EST_PROD_CPL.VLR_CUSTO_MD
    , dbo.EST_PROD_CPL_TRIB_EST.PERC_ICMS_EST AS PERC_ICMS_N_CONT_ESTA
    , dbo.EST_PROD_CPL.QTDE_PONTO_FIDEL
    , ISNULL(dbo.EST_PROD_CPL.PERC_DESC_FIDEL_MAX, 0) AS PERC_DESC_FIDEL_MAX
    , ISNULL(dbo.EST_PROD_CPL.PERC_DESC_FIDEL, 0) AS PERC_DESC_FIDEL
    , CONVERT(DATE, GETDATE()) AS DT_ESTOQUE
    , GETDATE() AS DT_HR_CARGA
    , ISNULL(EST_PROD_CPL.PERC_DESC_LIMITE, 100) AS PERC_DESC_LIMITE
    , EST_PROD_CPL_TRIB_EST.PERC_IBPT
    , ISNULL(EST_TRIB.ICMS, 0) AS ICMS
    , ISNULL(EST_TRIB.SUBS_TRIB, 0) AS SUBS_TRIB
    , ISNULL(EST_TRIB.ICMS_RD, 0) AS ICMS_RD
    , ISNULL(EST_TRIB.SUBS_TRIB_ANT, 0) AS SUBS_TRIB_ANT
    , ISNULL(EST_TRIB.ISENTO, 0) AS ISENTO
    , ISNULL(EST_TRIB.FLAG_OUTROS, 0) AS FLAG_OUTROS
    --ISNULL(EST_TRIB.CD_TRIB_FC,0) AS CD_TRIB_FC,
    , EST_PROD_CPL.FLAG_VERBA_DESCON
    , -CASE WHEN COALESCE(EST_PROD_PRC_BANDEIRA.STS_PROD, 0) IN(1, 2) THEN CASE WHEN EST_PROD_CPL.STS_PROD = 1 THEN EST_PROD_CPL.STS_PROD
                                                                                ELSE COALESCE(EST_PROD_PRC_BANDEIRA.STS_PROD, 0)
                                                                            END
            ELSE EST_PROD_CPL.STS_PROD
        END STS_PROD
    , ISNULL(EST_PROD_MOTIVO_STS.DS_MOTIVO_STS, ' ') DS_MOTIVO_STS
    --A.CD_CST_PIS,
    --A.PERC_PIS,
    --A.CST_TP_TRIB_PIS,
    --A.CD_CST_COFINS,
    --A.PERC_COFINS,
    --A.CST_TP_TRIB_COFINS,
    , EST_PROD_CPL_TRIB_EST.CST_PIS CD_CST_PIS
    , EST_PROD_CPL_TRIB_EST.PERC_PIS
    , EST_PROD_CPL_TRIB_EST.CST_TP_TRIB_PIS
    , EST_PROD_CPL_TRIB_EST.CST_COFINS CD_CST_COFINS
    , EST_PROD_CPL_TRIB_EST.PERC_COFINS
    , EST_PROD_CPL_TRIB_EST.CST_TP_TRIB_COFINS
    , 0 AS ALT_SIST
    , 0 AS REG_ALTERADO
    , EST_PROD.APRES_QT_VD
    , 0 AS qt_estq_ini_dia
    , 0 AS nr_oper_cel
    , EST_PROD_CPL.nr_serv_mun
    , EST_PROD_CPL_TRIB_EST.PERC_FECOP AS PERC_FCP
    , EST_PROD_COD_BENEF.MOTIVO_DESONERADO_ICMS
    , EST_PROD_COD_BENEF.ICMS_DESONERADO AS ICMS_DESONERADO
	, ISNULL(EST_PROD_COD_BENEF.CD_BENEF,'') CD_BENEF
	, ISNULL(EST_PROD_COD_BENEF_TP_MOV.CD_BENEF_RED,'') CD_BENEF_RED
    --, COALESCE((SELECT  * FROM  UFD_BUSCA_COD_BENEFICIO(EST_PROD.CD_EMP, EST_PROD.CD_PROD, EST_PROD_CPL_TRIB_EST.CD_TRIB_FC, GLB_CID.UF, EST_PROD_CPL_TRIB_EST.TP_MOV)), '') COLLATE SQL_Latin1_General_CP1_CI_AS AS CD_BENEF
	 
FROM 
    dbo.EST_PROD
    INNER JOIN dbo.EST_PROD_CPL ON dbo.EST_PROD.CD_EMP = dbo.EST_PROD_CPL.CD_EMP
                                    AND dbo.EST_PROD.CD_PROD = dbo.EST_PROD_CPL.CD_PROD
    INNER JOIN dbo.PRC_FILIAL ON dbo.EST_PROD_CPL.CD_EMP = dbo.PRC_FILIAL.CD_EMP
                                AND dbo.EST_PROD_CPL.CD_FILIAL = dbo.PRC_FILIAL.CD_FILIAL
	INNER JOIN PRC_REGIAO_FISCAL_PRC_FILIAL  ON PRC_REGIAO_FISCAL_PRC_FILIAL.CD_EMP = dbo.PRC_FILIAL.CD_EMP
								AND PRC_REGIAO_FISCAL_PRC_FILIAL.CD_FILIAL = dbo.PRC_FILIAL.CD_FILIAL			
    INNER JOIN dbo.GLB_CID ON dbo.PRC_FILIAL.CD_CID = dbo.GLB_CID.CD_CID
    LEFT JOIN dbo.EST_PROD_COD_BENEF ON dbo.EST_PROD.CD_PROD = dbo.EST_PROD_COD_BENEF.CD_PROD
                                        AND dbo.GLB_CID.UF = dbo.EST_PROD_COD_BENEF.UF
    INNER JOIN dbo.EST_PROD_CPL_TRIB_EST ON dbo.EST_PROD_CPL.CD_EMP = dbo.EST_PROD_CPL_TRIB_EST.CD_EMP
                                            AND dbo.EST_PROD_CPL.CD_FILIAL = dbo.EST_PROD_CPL_TRIB_EST.CD_FILIAL
                                            AND dbo.EST_PROD_CPL.CD_PROD = dbo.EST_PROD_CPL_TRIB_EST.CD_PROD
											AND EST_PROD_CPL_TRIB_EST.CD_REGIAO_FISCAL= PRC_REGIAO_FISCAL_PRC_FILIAL.CD_REGIAO_FISCAL
											
	--CD_BENEF_RED	
	LEFT JOIN dbo.EST_PROD_COD_BENEF_TP_MOV ON
		dbo.EST_PROD_CPL_TRIB_EST.CD_EMP = dbo.EST_PROD_COD_BENEF_TP_MOV.CD_EMP
		AND dbo.EST_PROD_CPL_TRIB_EST.CD_PROD = dbo.EST_PROD_COD_BENEF_TP_MOV.CD_PROD
		AND dbo.EST_PROD_CPL_TRIB_EST.UF_FILIAL = dbo.EST_PROD_COD_BENEF_TP_MOV.UF	
		AND	EST_PROD_CPL_TRIB_EST.TP_MOV = dbo.EST_PROD_COD_BENEF_TP_MOV.TP_MOV	
	
	
    INNER JOIN EST_TRIB ON EST_PROD_CPL_TRIB_EST.CD_TRIB = EST_TRIB.CD_TRIB
    LEFT JOIN EST_PROD_MOTIVO_STS ON EST_PROD_MOTIVO_STS.CD_MOTIVO_STS = EST_PROD_CPL.CD_MOTIVO_STS
    --OUTER APPLY UFD_EST_PROD_TRIB_PIS_COFINS(EST_PROD_CPL.CD_EMP,EST_PROD_CPL.CD_FILIAL,0,EST_PROD_CPL.CD_PROD,0,0,0) A
    LEFT JOIN PRC_BANDEIRA_PRC_FILIAL ON EST_PROD_CPL.CD_EMP = PRC_BANDEIRA_PRC_FILIAL.CD_EMP
                                        AND EST_PROD_CPL.CD_FILIAL = PRC_BANDEIRA_PRC_FILIAL.CD_FILIAL
    LEFT JOIN EST_PROD_PRC_BANDEIRA ON PRC_BANDEIRA_PRC_FILIAL.CD_EMP = EST_PROD_PRC_BANDEIRA.CD_EMP
                                        AND PRC_BANDEIRA_PRC_FILIAL.CD_BANDEIRA = EST_PROD_PRC_BANDEIRA.CD_BANDEIRA
                                        AND EST_PROD_CPL.CD_PROD = EST_PROD_PRC_BANDEIRA.CD_PROD
WHERE EST_PROD_CPL.CD_EMP = 1
    AND (dbo.EST_PROD_CPL_TRIB_EST.TP_MOV = 0)
    AND (dbo.EST_PROD_CPL_TRIB_EST.TP_TRANSA = 1)
    AND (dbo.EST_PROD_CPL.TP_PROD IN(0, 8, 9, 10, 11));
GO